 
<?php if(isset($expert)): ?>
<?php $__env->startSection('main_title','Update an Expert'); ?>
<?php else: ?>
<?php $__env->startSection('main_title','Add an Expert'); ?>
<?php endif; ?>

<?php $__env->startSection('title','Add Expert'); ?>
<?php $__env->startSection('breadcrumb','Expert'); ?>

<?php $__env->startSection('content'); ?>

<div class="card card-default">
                     <div class="card-header">
                        <h3 class="card-title">Expand Your Expertise
                           Network</h3>
                        <div class="card-tools">
                           <button type="button" class="btn btn-tool"
                              data-card-widget="collapse">
                              <i class="fas fa-minus"></i>
                           </button>
                           <button type="button" class="btn btn-tool"
                              data-card-widget="remove">
                              <i class="fas fa-times"></i>
                           </button>
                        </div>
                     </div>
                     <form action="<?php echo e(isset($expert) ? route('add_expert.update', ['id' => $expert->id ]) : route('add_expert.create')); ?>" method="POST" enctype="multipart/form-data">
                         
                    
                          <?php echo csrf_field(); ?>
                     
                     <!-- /.card-header -->
                     <div class="card-body">
                        <div class="row">
                           <div class="col-md-2">
                              <div class="form-group">
                                 <label>Gender</label>
                                 <select class="form-control select2" name="gender"
                                    style="width: 100%;">
                                    <option selected="selected">Choose
                                       Gender</option>
                                    <option value="1" <?php echo e(isset($expert) && $expert->gender == 1 ? 'selected' : ''); ?> >Mr.</option>
                                    <option value="2" <?php echo e(isset($expert) && $expert->gender == 2 ? 'selected' : ''); ?>>Mrs.</option>
                                    <option value="3" <?php echo e(isset($expert) && $expert->gender == 3 ? 'selected' : ''); ?> >Miss.</option>
                                 </select>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <!-- /.col -->
                           <div class="col-md-5">
                              <div class="form-group">
                                 <label>First Name</label>
                                 <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i
                                             class="far fa-user"></i></span>
                                    </div>
                                    <input type="text" class="form-control" name="first_name" value="<?php echo e($expert->first_name ?? ''); ?>">
                                 </div>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-5">
                              <div class="form-group">
                                 <label>Last Name</label>
                                 <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i
                                             class="far fa-user"></i></span>
                                    </div>
                                    <input type="text" class="form-control" name="last_name" value="<?php echo e($expert->last_name ?? ''); ?>">
                                 </div>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <!-- /.col -->
                        </div>
                        <div class="row">
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Qualification</label>
                                 <select class="form-control select2" name="qualification"
                                    style="width: 100%;">
                                    <option selected="selected">Choose
                                       Qualification</option>
                                    <option value="B.Tech" <?php echo e(isset($expert) && $expert->qualification == 'B.Tech' ? 'selected' : ''); ?>>B.Tech</option>
                                    <option value="M.Tech"  <?php echo e(isset($expert) && $expert->qualification == 'M.Tech' ? 'selected' : ''); ?>>M.Tech</option>
                                    <option value="Phd"  <?php echo e(isset($expert) && $expert->qualification == 'Phd' ? 'selected' : ''); ?>>Phd</option>
                                    <option value="PG Diploma in Management
                                       (PGDM)"  <?php echo e(isset($expert) && $expert->qualification == 'PG Diploma in Management
                                       (PGDM)' ? 'selected' : ''); ?>>PG Diploma in Management
                                       (PGDM)</option>
                                    <option value="MBA (Masters in Business
                                       Administration)"  <?php echo e(isset($expert) && $expert->qualification == '"MBA (Masters in Business
                                       Administration)' ? 'selected' : ''); ?>>MBA (Masters in Business
                                       Administration)</option>
                                    <option value="Master of Technology
                                       (MTech)"  <?php echo e(isset($expert) && $expert->qualification == 'Master of Technology
                                       (MTech)' ? 'selected' : ''); ?>>Master of Technology
                                       (MTech)</option>
                                    <option value="PGDM in Hotel Management" <?php echo e(isset($expert) && $expert->qualification == 'PGDM in Hotel Management' ? 'selected' : ''); ?>>PGDM in Hotel Management</option>
                                    <option value="Post-Graduate-Programme-In-Management
                                       (PGPM)"  <?php echo e(isset($expert) && $expert->qualification == 'Post-Graduate-Programme-In-Management
                                       (PGPM)' ? 'selected' : ''); ?>>Post-Graduate-Programme-In-Management
                                       (PGPM)</option>
                                    <option value="Certification in Finance and
                                       Accounting (CFA)" <?php echo e(isset($expert) && $expert->qualification == 'Certification in Finance and
                                       Accounting (CFA)' ? 'selected' : ''); ?>>Certification in Finance and
                                       Accounting (CFA)</option>
                                    <option value="Project Management"  <?php echo e(isset($expert) && $expert->qualification == 'Project Management'? 'selected' : ''); ?>>Project Management</option>
                                    <option value="Business Accounting and
                                       Taxation"  <?php echo e(isset($expert) && $expert->qualification == 'Business Accounting and
                                       Taxation' ? 'selected' : ''); ?>>Business Accounting and
                                       Taxation</option>
                                    <option value="PG Diploma in Digital Marketing or
                                       Business Analytics Courses"  <?php echo e(isset($expert) && $expert->qualification == 'PG Diploma in Digital Marketing or
                                       Business Analytics Courses' ? 'selected' : ''); ?>>PG Diploma in Digital Marketing or
                                       Business Analytics Courses</option>
                                    <option value="Masters in Data Science or Machine
                                       Learning"  <?php echo e(isset($expert) && $expert->qualification == 'Masters in Data Science or Machine
                                       Learning' ? 'selected' : ''); ?>>Masters in Data Science or Machine
                                       Learning</option>
                                    <option value="Master in Commerce (MCom)" <?php echo e(isset($expert) && $expert->qualification == 'Master in Commerce (MCom)' ? 'selected' : ''); ?>>Master in Commerce (MCom)</option>
                                    <option value="Post Graduate Diploma In Educational
                                       Management And Administration
                                       (PGDEMA)"  <?php echo e(isset($expert) && $expert->qualification == 'Post Graduate Diploma In Educational
                                       Management And Administration
                                       (PGDEMA)' ? 'selected' : ''); ?>>Post Graduate Diploma In Educational
                                       Management And Administration
                                       (PGDEMA)</option>
                                    <option value="Tally"  <?php echo e(isset($expert) && $expert->qualification == 'Tally' ? 'selected' : ''); ?>>Tally</option>
                                    <option value="PGDM in Finance"  <?php echo e(isset($expert) && $expert->qualification == 'PGDM in Finance' ? 'selected' : ''); ?>>PGDM in Finance</option>
                                    <option value="PGD in Computer Management" <?php echo e(isset($expert) && $expert->qualification == 'PGD in Computer Management' ? 'selected' : ''); ?>>PGD in Computer Management</option>
                                    <option value="Mobile App Development" <?php echo e(isset($expert) && $expert->qualification == 'Mobile App Development' ? 'selected' : ''); ?>>Mobile App Development</option>
                                 </select>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <!-- /.col -->
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Years Of Exp</label>
                                 <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i
                                             class="far fa-calendar"></i></span>
                                    </div>
                                    <input type="text" class="form-control" name="experiance_years" value="<?php echo e($expert->experiance_years ?? ''); ?>">
                                 </div>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Designation</label>
                                 <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i
                                             class="far fa-calendar"></i></span>
                                    </div>
                                    <input type="text" class="form-control" name="designation" value="<?php echo e($expert->designation ?? ''); ?>">
                                 </div>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Position</label>
                                 <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i
                                             class="far fa-calendar"></i></span>
                                    </div>
                                    <input type="text" class="form-control" name="position" value="<?php echo e($expert->position ?? ''); ?>">
                                 </div>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Skill</label>
                                 <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i
                                             class="far fa-calendar"></i></span>
                                    </div>
                                    <input type="text" class="form-control" name="skill" value="<?php echo e($expert->skill ?? ''); ?>">
                                 </div>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Interest</label>
                                 <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i
                                             class="far fa-calendar"></i></span>
                                    </div>
                                    <input type="text" class="form-control" name="interest" value="<?php echo e($expert->interest ?? ''); ?>">
                                 </div>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Expertise Category</label>
                                 <select class="select2" multiple="multiple" name="expertise_category[]"
                                    data-placeholder="Assign a Category"
                                    style="width: 100%;" id="expertise_category">
                                    <option>Choose Category</option>
                                    <option value="Sustainable Habitat">Sustainable Habitat</option>
                                    <option value="Indic Studies of Natural
                                       Resources">Indic Studies of Natural
                                       Resources</option>
                                    <option value="Indic Studies of Cultural">Indic Studies of Cultural
                                       Resources</option>
                                 </select>
                              </div>
                              <input type="hidden" id="expertise_hidden" value="<?php echo e($expert->expertise_category ?? ''); ?>" />
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Email</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i
                                             class="far fa-envelope"></i></span>
                                    </div>
                                    <input type="email" class="form-control" name="email" value="<?php echo e($expert->email ?? ''); ?>">
                                 </div>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Phone Number</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i
                                             class="fa fa-phone"></i></span>
                                    </div>
                                    <input type="phone" class="form-control" name="mobile_number" value="<?php echo e($expert->mobile_number ?? ''); ?>">
                                 </div>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>PAN Card</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i class="	far fa-file-image"></i>
</span>
                                    </div>
                                    <input type="file" class="form-control" name="pan_photo">
                                 </div>
                                 <?php if(isset($expert)): ?>
												<?php
                                                    $imagePath = public_path('dist/img/pan_photo/' . ($expert->pan_photo ?? ''));
                                                ?>
            									<?php if(file_exists($imagePath) && !empty($expert->pan_photo)): ?>
                                                    <img src="<?php echo e(URL::asset('dist/img/pan_photo/' . $expert->pan_photo)); ?>" style="width:100px; height:100px;">
                                                <?php endif; ?>
                                                <?php endif; ?>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Aadhar Card</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i class="	far fa-file-image"></i>
</span>
                                    </div>
                                    <input type="file" class="form-control" name="aadhar_photo">
                                 </div>
                                  <?php if(isset($expert)): ?>
												<?php
                                                    $imagePath = public_path('dist/img/aadhar_photo/' . ($expert->aadhar_photo ?? ''));
                                                ?>
            									<?php if(file_exists($imagePath) && !empty($expert->aadhar_photo)): ?>
                                                    <img src="<?php echo e(URL::asset('dist/img/aadhar_photo/' . $expert->aadhar_photo)); ?>" style="width:100px; height:100px;">
                                                <?php endif; ?>
                                                <?php endif; ?>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Certificate</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i class="	far fa-file-image"></i>
</span>
                                    </div>
                                    <input type="file" class="form-control" name="certificate">
                                 </div>
                                 <?php if(isset($expert)): ?>
												<?php
                                                    $imagePath = public_path('dist/img/certificate/' . ($expert->certificate ?? ''));
                                                ?>
            									<?php if(file_exists($imagePath) && !empty($expert->certificate)): ?>
                                                    <img src="<?php echo e(URL::asset('dist/img/certificate/' . $expert->certificate)); ?>" style="width:100px; height:100px;">
                                                <?php endif; ?>
                                                <?php endif; ?>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <div class="col-md-4">
                              <div class="form-group">
                                 <label>Photo</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                       <span class="input-group-text"><i class="	far fa-file-image"></i>
</span>
                                    </div>
                                    <input type="file" class="form-control" name="photo">
                                 </div>
                                  <?php if(isset($expert)): ?>
												<?php
                                                    $imagePath = public_path('dist/img/photo/' . ($expert->photo ?? ''));
                                                ?>
            									<?php if(file_exists($imagePath) && !empty($expert->photo)): ?>
                                                    <img src="<?php echo e(URL::asset('dist/img/photo/' . $expert->photo)); ?>" style="width:100px; height:100px;">
                                                <?php endif; ?>
                                                <?php endif; ?>
                              </div>
                              <!-- /.form-group -->
                           </div>
                           <!-- /.col -->
                        </div>
                        <div class="row">
                           <div class="col-md-12">
                              <div class="card card-success">
                                 <div class="card-header">
                                    <h3 class="card-title">Assign the Interest
                                       Level</h3>
                                 </div>
                                 <div class="card-body">
                                    <!-- Minimal style -->
                                    <div class="row">
                                       <div class="col-sm-6">
                                          <!-- checkbox -->
                                          <div class="form-group clearfix">
                                             <div
                                                class="icheck-success d-inline">
                                                <input type="checkbox"
                                                   id="level1" name="level1" value="Applied Research Papers in Sustainable Habitat" <?php echo e(isset($expert) && $expert->level1 == 'Applied Research Papers in Sustainable Habitat' ? 'checked' : ''); ?>>
                                                <label
                                                   for="level1">Applied
                                                   Research Papers in
                                                   Sustainable Habitat</label>
                                             </div>
                                          </div>
                                       </div>
                                       <div class="col-sm-6">
                                          <!-- checkbox -->
                                          <div class="form-group clearfix">
                                             <div
                                                class="icheck-success d-inline">
                                                <input type="checkbox"
                                                   id="level2" name="level2" value="Applied Research Papers in Indic Studies of Natural Resources"  <?php echo e(isset($expert) && $expert->level2 == 'Applied Research Papers in Indic Studies of Natural Resources' ? 'checked' : ''); ?>>
                                                <label
                                                   for="level2">Applied
                                                   Research Papers in Indic
                                                   Studies of Natural
                                                   Resources</label>
                                             </div>
                                          </div>
                                       </div>
                                       <div class="col-sm-6">
                                          <!-- checkbox -->
                                          <div class="form-group clearfix">
                                             <div
                                                class="icheck-success d-inline">
                                                <input type="checkbox"
                                                   id="level3" name="level3" value="Applied Research Papers in Indic Studies of Cultural Resources" <?php echo e(isset($expert) && $expert->level3 == 'Applied Research Papers in Indic Studies of Cultural Resources' ? 'checked' : ''); ?>>
                                                <label
                                                   for="level3">Applied
                                                   Research Papers in Indic
                                                   Studies of Cultural
                                                   Resources</label>
                                             </div>
                                          </div>
                                       </div>
                                       <div class="col-sm-6">
                                          <!-- checkbox -->
                                          <div class="form-group clearfix">
                                             <div
                                                class="icheck-success d-inline">
                                                <input type="checkbox"
                                                   id="level4" name="level4" value="Descriptive Papers Showcasing Natural Resources" <?php echo e(isset($expert) && $expert->level4 == 'Descriptive Papers Showcasing Natural Resources' ? 'checked' : ''); ?>>
                                                <label for="level4">
                                                   Descriptive Papers Showcasing
                                                   Natural Resources</label>
                                             </div>
                                          </div>
                                       </div>
                                       <div class="col-sm-6">
                                          <!-- checkbox -->
                                          <div class="form-group clearfix">
                                             <div
                                                class="icheck-success d-inline">
                                                <input type="checkbox"
                                                   id="level5" name="level5" value="Descriptive Papers Showcasing Cultural Resources" <?php echo e(isset($expert) && $expert->level5 == 'Descriptive Papers Showcasing Cultural Resources' ? 'checked' : ''); ?>>
                                                <label
                                                   for="level5">Descriptive
                                                   Papers Showcasing Cultural
                                                   Resources</label>
                                             </div>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                                 <!-- /.card-body -->
                                 <!--<div class="card-footer">-->
                                 <!--   Many more skins available. <a-->
                                 <!--      href="https://bantikyan.github.io/icheck-bootstrap/">Documentation</a>-->
                                 <!--</div>-->
                              </div>
                              <!-- /.card -->
                           </div>
                        </div>
                        <div class="row">
                           <div class="col-md-6">
                              <div class="card card-danger">
                                 <div class="card-header">
                                    <h3 class="card-title">Bank Details</h3>
                                 </div>
                                 <div class="card-body">
                                    <div class="form-group">
                                       <label>Bank A/c Number</label>
                                       <div class="input-group">
                                          <div class="input-group-prepend">
                                             <span class="input-group-text"><i
                                                   class="fas fa-film"></i></span>
                                          </div>
                                          <input type="text"
                                             class="form-control" name-"bank_account_number" value="<?php echo e($expert->bank_account_number ?? ''); ?>">
                                       </div>
                                       <!-- /.input group -->
                                    </div>
                                    <div class="form-group">
                                       <label>Bank A/c Number</label>
                                       <div class="input-group">
                                          <div class="input-group-prepend">
                                             <span class="input-group-text"><i
                                                   class="fas fa-film"></i></span>
                                          </div>
                                          <input type="text"
                                             class="form-control" name="bank_account_number" value="<?php echo e($expert->bank_account_number ?? ''); ?>">
                                       </div>
                                       <!-- /.input group -->
                                    </div>
                                    <!-- /.form group -->
                                    <div class="form-group">
                                       <label>Account Type</label>
                                       <div class="input-group">
                                          <select class="form-control select2"
                                             style="width: 100%;" name="bank_account_type">
                                             <option selected="selected">Choose
                                                Account Type</option>
                                             <option value="1" <?php echo e(isset($expert) && $expert->bank_account_type == '1' ? 'selected' : ''); ?>>Savings</option>
                                             <option value="2" <?php echo e(isset($expert) && $expert->bank_account_type == '2' ? 'selected' : ''); ?>>Current</option>
                                          </select>
                                       </div>
                                       <!-- /.input group -->
                                    </div>
                                    <!-- /.form group -->
                                    <div class="form-group">
                                       <label>Bank Name</label>
                                       <div class="input-group">
                                          <div class="input-group-prepend">
                                             <span class="input-group-text"><i
                                                   class="fas fa-building"></i></span>
                                          </div>
                                          <input type="text"
                                             class="form-control" name="bank_name" value="<?php echo e($expert->bank_name ?? ''); ?>">
                                       </div>
                                       <!-- /.input group -->
                                    </div>
                                    <!-- /.form group -->
                                    <div class="form-group">
                                       <label>IFSC Code</label>
                                       <div class="input-group">
                                          <div class="input-group-prepend">
                                             <span class="input-group-text"><i
                                                   class="fas fa-file"></i></span>
                                          </div>
                                          <input type="text"
                                             class="form-control" name="bank_ifsc" value="<?php echo e($expert->bank_ifsc ?? ''); ?>">
                                       </div>
                                       <!-- /.input group -->
                                    </div>
                                    <div class="form-group">
                                       <label>UPI</label>
                                       <div class="input-group">
                                          <div class="input-group-prepend">
                                             <span class="input-group-text"><i
                                                   class="fas fa-phone"></i></span>
                                          </div>
                                          <input type="text"
                                             class="form-control" name="upi" value="<?php echo e($expert->upi ?? ''); ?>">
                                       </div>
                                       <!-- /.input group -->
                                    </div>
                                    <!-- /.form group -->
                                 </div>
                                 <!-- /.card-body -->
                              </div>
                              <!-- /.card -->
                           </div>
                           <!-- /.col (left) -->
                           <div class="col-md-6">
                              <div class="card card-primary">
                                 <div class="card-header">
                                    <h3 class="card-title">Address</h3>
                                 </div>
                                 <div class="card-body">
                                    <!-- Date -->
                                    <div class="form-group">
                                       <label>Address Line#1</label>
                                       <div class="input-group date"
                                          id="reservationdate"
                                          data-target-input="nearest">
                                          <input type="text"
                                             class="form-control" name="address_line_1" value="<?php echo e($expert->address_line_1 ?? ''); ?>">
                                          <div class="input-group-append"
                                             data-target="#reservationdate"
                                             data-toggle="datetimepicker">
                                             <div class="input-group-text"><i
                                                   class="fa fa-home"></i></div>
                                          </div>
                                       </div>
                                    </div>
                                    <div class="form-group">
                                       <label>Address Line#2</label>
                                       <div class="input-group date"
                                          id="reservationdate"
                                          data-target-input="nearest">
                                          <input type="text"
                                             class="form-control" name="address_line_2" value="<?php echo e($expert->address_line_2 ?? ''); ?>">
                                          <div class="input-group-append"
                                             data-target="#reservationdate"
                                             data-toggle="datetimepicker">
                                             <div class="input-group-text"><i
                                                   class="fa fa-map"></i></div>
                                          </div>
                                       </div>
                                    </div>
                                    <input type="hidden" name="district_hidden" id="district_hidden" value="<?php echo e($expert->district_id ?? ''); ?>" />
                                    <input type="hidden" name="city_hidden" id="city_hidden" value="<?php echo e($expert->city_id ?? ''); ?>" />
                                    <div class="row">
                                       <div class="form-group  col-md-4">
                                          <label for="inputState">State</label>
                                          <select class="form-control"
                                             id="inputState" name="state" onchange="inputState_change($(this))" >
                                             <option value="SelectState" >Select
                                                State</option>
                                             <?php $__currentLoopData = $state; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             <option value="<?php echo e($st->id); ?>" <?php echo e(isset($expert) && $expert->state_id == $st->id ? 'selected' : ''); ?>><?php echo e($st->state_title); ?></option>
                                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                          </select>
                                       </div>
                                       <div class="form-group col-md-4">
                                          <label
                                             for="inputDistrict">District</label>
                                          <select class="form-control"
                                             id="inputDistrict" name="district"
                                             onchange="inputDistrict_change($(this))">
                                             <option value>-- select one --
                                             </option>
                                          </select>
                                       </div>
                                       <div class="form-group  col-md-4">
                                          <label for="inputCity">City</label>
                                          <select class="form-control"
                                             id="inputCity" name="city" >
                                             <option value="SelectCity">Select
                                                City</option>
                                            
                                          </select>
                                       </div>
                                    </div>
                                    <div class="form-group">
                                       <label>PIN Code</label>
                                       <div class="input-group date"
                                          id="reservationdatetime1"
                                          data-target-input="nearest">
                                          <input type="text"
                                             class="form-control" name="pincode" value="<?php echo e($expert->pincode ?? ''); ?>" />
                                          <div class="input-group-append">
                                             <div class="input-group-text"><i
                                                   class="fa fa-calendar"></i></div>
                                          </div>
                                       </div>
                                    </div>
                                    <div class="form-group">
                                       <label>DOB</label>
                                       <div class="input-group date"
                                          id="reservationdatetime"
                                          data-target-input="nearest">
                                          <input type="text"
                                             class="form-control datetimepicker-input"
                                             data-target="#reservationdatetime"
                                             name="dob"  value="<?php echo e($expert->dob ?? ''); ?>" />
                                          <div class="input-group-append"
                                             data-target="#reservationdatetime"
                                             data-toggle="datetimepicker">
                                             <div class="input-group-text"><i
                                                   class="fa fa-calendar"></i></div>
                                          </div>
                                       </div>
                                    </div>
                                    <!-- /.form group -->
                                    <div class="form-group">
                                       <label>Current Working
                                          Organization</label>
                                       <div class="input-group">
                                          <div class="input-group-prepend">
                                             <span class="input-group-text">
                                                <i class="far fa-building"></i>
                                             </span>
                                          </div>
                                          <input type="text"
                                             class="form-control float-right"
                                             id="reservation" name="company_name" value="<?php echo e($expert->company_name ?? ''); ?>">
                                       </div>
                                       <!-- /.input group -->
                                    </div>
                                    <!-- /.form group -->
                                 </div>
                              </div>
                              <!-- /.card -->
                              <!-- iCheck -->
                           </div>
                           <!-- /.col (right) -->
                        </div>
                        <div class="row">
                            <input type="submit" name="submit" value="<?php if(isset($expert)): ?> Update <?php else: ?> Add <?php endif; ?>" class="btn btn-success" />
                        </div>
                     </div>
                     </form>
                     <!-- /.card-body -->
                     <div class="card-footer">
                        <a href="experts.html">Visit</a> Enrich Your Expertise
                        Pool
                     </div>
                  </div>
                  
                  <!--<div class="row">-->
                  <!--   <div class="col-md-12">-->
                  <!--      <div class="card card-default">-->
                  <!--         <div class="card-header">-->
                  <!--            <h3 class="card-title">Upload All Required-->
                  <!--               Documents</h3>-->
                  <!--         </div>-->
                  <!--         <div class="card-body">-->
                  <!--            <div id="actions" class="row">-->
                  <!--               <div class="col-lg-6">-->
                  <!--                  <div class="btn-group w-100">-->
                  <!--                     <span-->
                  <!--                        class="btn btn-success col fileinput-button">-->
                  <!--                        <i class="fas fa-plus"></i>-->
                  <!--                        <span>Add files</span>-->
                  <!--                     </span>-->
                  <!--                     <button type="submit"-->
                  <!--                        class="btn btn-primary col start">-->
                  <!--                        <i class="fas fa-upload"></i>-->
                  <!--                        <span>Start upload</span>-->
                  <!--                     </button>-->
                  <!--                     <button type="reset"-->
                  <!--                        class="btn btn-warning col cancel">-->
                  <!--                        <i class="fas fa-times-circle"></i>-->
                  <!--                        <span>Cancel upload</span>-->
                  <!--                     </button>-->
                  <!--                  </div>-->
                  <!--               </div>-->
                  <!--               <div-->
                  <!--                  class="col-lg-6 d-flex align-items-center">-->
                  <!--                  <div class="fileupload-process w-100">-->
                  <!--                     <div id="total-progress"-->
                  <!--                        class="progress progress-striped active"-->
                  <!--                        role="progressbar" aria-valuemin="0"-->
                  <!--                        aria-valuemax="100" aria-valuenow="0">-->
                  <!--                        <div-->
                  <!--                           class="progress-bar progress-bar-success"-->
                  <!--                           style="width:0%;"-->
                  <!--                           data-dz-uploadprogress></div>-->
                  <!--                     </div>-->
                  <!--                  </div>-->
                  <!--               </div>-->
                  <!--            </div>-->
                  <!--            <div class="table table-striped files"-->
                  <!--               id="previews">-->
                  <!--               <div id="template" class="row mt-2">-->
                  <!--                  <div class="col-auto">-->
                  <!--                     <span class="preview"><img src="data:,"-->
                  <!--                           alt data-dz-thumbnail /></span>-->
                  <!--                  </div>-->
                  <!--                  <div class="col d-flex align-items-center">-->
                  <!--                     <p class="mb-0">-->
                  <!--                        <span class="lead"-->
                  <!--                           data-dz-name></span>-->
                  <!--                        (<span data-dz-size></span>)-->
                  <!--                     </p>-->
                  <!--                     <strong class="error text-danger"-->
                  <!--                        data-dz-errormessage></strong>-->
                  <!--                  </div>-->
                  <!--                  <div-->
                  <!--                     class="col-4 d-flex align-items-center">-->
                  <!--                     <div-->
                  <!--                        class="progress progress-striped active w-100"-->
                  <!--                        role="progressbar" aria-valuemin="0"-->
                  <!--                        aria-valuemax="100" aria-valuenow="0">-->
                  <!--                        <div-->
                  <!--                           class="progress-bar progress-bar-success"-->
                  <!--                           style="width:0%;"-->
                  <!--                           data-dz-uploadprogress></div>-->
                  <!--                     </div>-->
                  <!--                  </div>-->
                  <!--                  <div-->
                  <!--                     class="col-auto d-flex align-items-center">-->
                  <!--                     <div class="btn-group">-->
                  <!--                        <button class="btn btn-primary start">-->
                  <!--                           <i class="fas fa-upload"></i>-->
                  <!--                           <span>Start</span>-->
                  <!--                        </button>-->
                  <!--                        <button data-dz-remove-->
                  <!--                           class="btn btn-warning cancel">-->
                  <!--                           <i class="fas fa-times-circle"></i>-->
                  <!--                           <span>Cancel</span>-->
                  <!--                        </button>-->
                  <!--                        <button data-dz-remove-->
                  <!--                           class="btn btn-danger delete">-->
                  <!--                           <i class="fas fa-trash"></i>-->
                  <!--                           <span>Delete</span>-->
                  <!--                        </button>-->
                  <!--                     </div>-->
                  <!--                  </div>-->
                  <!--               </div>-->
                  <!--            </div>-->
                  <!--         </div>-->
                           <!-- /.card-body -->
                  <!--         <div class="card-footer">-->
                  <!--            <a href="experts">View</a> Our Experts-->
                  <!--         </div>-->
                  <!--      </div>-->
                        <!-- /.card -->
                  <!--   </div>-->
                  <!--</div>-->
                  
                

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/crmone/public_html/admin/resources/views/add_expert.blade.php ENDPATH**/ ?>