

<?php $__env->startSection('main_title','Expert'); ?>
<?php $__env->startSection('title','Add Expert'); ?>
<?php $__env->startSection('breadcrumb','Contact'); ?>

<?php $__env->startSection('content'); ?>

<div class="card card-solid">
                  <div class="card-body pb-0">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Research Paper Proofreading Specialists</h3>
                </div>
            </div>
        </div>
        <?php $__currentLoopData = $expert; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ex): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-12 col-sm-6 col-md-4 d-flex align-items-stretch flex-column">
                <div class="card bg-light d-flex flex-fill">
                    <div class="card-header text-muted border-bottom-0">
                       <?php echo e($ex->qualification); ?>

                    </div>
                    <div class="card-body pt-0">
                        <div class="row">
                            <div class="col-7">
                                <h2 class="lead"><b>
                                    <?php if($ex->gender == '1'): ?> Mr 
                                    <?php elseif($ex->gender == '2'): ?> Mrs 
                                    <?php else: ?> Miss 
                                    <?php endif; ?> 
                                    <?php echo e($ex->first_name); ?> <?php echo e($ex->last_name); ?>

                                </b></h2>
                                <p class="text-muted text-sm"><b>About: </b> Web Designer / UX / Graphic Artist / Coffee Lover</p>
                                <ul class="ml-4 mb-0 fa-ul text-muted">
                                    <li class="small"><span class="fa-li"><i class="fas fa-lg fa-building"></i></span><?php echo e($ex->district->district_title); ?>, <?php echo e($ex->city->name); ?></li>
                                    <li class="small"><span class="fa-li"><i class="fas fa-lg fa-phone"></i></span>+ <?php echo e($ex->mobile_number); ?></li>
                                </ul>
                            </div>
                            <div class="col-5 text-center">
                                <?php if(empty($ex->photo)): ?>
                                <img src="dist/img/user1-128x128.jpg" alt="user-avatar" class="img-circle img-fluid">
                                <?php else: ?>
                                <img src="<?php echo e(URL::asset('dist/img/photo/'.$ex->photo)); ?>" alt="user-avatar" class="img-circle img-fluid">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="text-right">
                            <a href="<?php echo e(route('add_expert.edit',$ex->id)); ?>" class="btn btn-sm btn-primary"><i class="fas fa-user"></i> Edit</a>
                            <a href="compose.html" class="btn btn-sm bg-teal"><i class="fas fa-comments"></i></a>
                            <a href="#" class="btn btn-sm btn-success"><i class="fas fa-user"></i> View Profile</a>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<div class="card-footer">
    <nav aria-label="Custom Pagination">
        <ul class="pagination justify-content-center m-0">
            <?php if($expert->onFirstPage()): ?>
                <li class="page-item disabled"><span class="page-link">&laquo;</span></li>
            <?php else: ?>
                <li class="page-item"><a class="page-link" href="<?php echo e($expert->previousPageUrl()); ?>" rel="prev">&laquo;</a></li>
            <?php endif; ?>

            <?php $__currentLoopData = $expert->getUrlRange(1, $expert->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="page-item <?php echo e($page == $expert->currentPage() ? 'active' : ''); ?>">
                    <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if($expert->hasMorePages()): ?>
                <li class="page-item"><a class="page-link" href="<?php echo e($expert->nextPageUrl()); ?>" rel="next">&raquo;</a></li>
            <?php else: ?>
                <li class="page-item disabled"><span class="page-link">&raquo;</span></li>
            <?php endif; ?>
        </ul>
    </nav>
</div>

                  <!-- /.card-footer -->
               </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/crmone/public_html/admin/resources/views/view_expert.blade.php ENDPATH**/ ?>