<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Auth\AuthController;

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DonorController;
use App\Http\Controllers\ApplicantController;
use App\Http\Controllers\ExpertController;
use App\Http\Controllers\FaqController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });


Route::get('/', [AuthController::class, 'index'])->name('login');

Route::post('post-login', [AuthController::class, 'postLogin'])->name('login.post'); 

Route::get('registration', [AuthController::class, 'registration'])->name('register');

Route::post('post-registration', [AuthController::class, 'postRegistration'])->name('register.post'); 

Route::get('dashboard', [DashboardController::class, 'index']); 

Route::get('logout', [AuthController::class, 'logout'])->name('logout');


Route::get('donor', [DonorController::class, 'index']); 

Route::get('applicant', [ApplicantController::class, 'index']); 

Route::get('add_expert', [ExpertController::class, 'index']); 

Route::get('view_expert', [ExpertController::class, 'view'])->name('view_expert'); 
Route::post('add_expert/district_list', [ExpertController::class, 'district_list'])->name('add_expert.district_list'); 


Route::post('add_expert/city_list', [ExpertController::class, 'city_list'])->name('add_expert.city_list'); 

Route::post('add_expert/create', [ExpertController::class, 'create'])->name('add_expert.create'); 

Route::get('add_expert/edit/{id}', [ExpertController::class, 'edit'])->name('add_expert.edit'); 



Route::post('add_expert/update/{id}', [ExpertController::class, 'update'])->name('add_expert.update'); 


Route::post('faq/create', [FaqController::class, 'create'])->name('faq.create'); 
Route::get('faq', [FaqController::class, 'index']); 
Route::get('faq/edit/{id}', [FaqController::class, 'edit'])->name('faq.edit'); 
Route::get('faq/view', [FaqController::class, 'view'])->name('faq.view'); 