@extends('layout')

@section('main_title','Expert')
@section('title','Add Expert')
@section('breadcrumb','Contact')

@section('content')

<div class="card card-solid">
                  <div class="card-body pb-0">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Research Paper Proofreading Specialists</h3>
                </div>
            </div>
        </div>
        @foreach($expert as $ex)
            <div class="col-12 col-sm-6 col-md-4 d-flex align-items-stretch flex-column">
                <div class="card bg-light d-flex flex-fill">
                    <div class="card-header text-muted border-bottom-0">
                       {{$ex->qualification}}
                    </div>
                    <div class="card-body pt-0">
                        <div class="row">
                            <div class="col-7">
                                <h2 class="lead"><b>
                                    @if($ex->gender == '1') Mr 
                                    @elseif($ex->gender == '2') Mrs 
                                    @else Miss 
                                    @endif 
                                    {{$ex->first_name}} {{$ex->last_name}}
                                </b></h2>
                                <p class="text-muted text-sm"><b>About: </b> Web Designer / UX / Graphic Artist / Coffee Lover</p>
                                <ul class="ml-4 mb-0 fa-ul text-muted">
                                    <li class="small"><span class="fa-li"><i class="fas fa-lg fa-building"></i></span>{{$ex->district->district_title}}, {{$ex->city->name}}</li>
                                    <li class="small"><span class="fa-li"><i class="fas fa-lg fa-phone"></i></span>+ {{$ex->mobile_number}}</li>
                                </ul>
                            </div>
                            <div class="col-5 text-center">
                                @if(empty($ex->photo))
                                <img src="dist/img/user1-128x128.jpg" alt="user-avatar" class="img-circle img-fluid">
                                @else
                                <img src="{{URL::asset('dist/img/photo/'.$ex->photo)}}" alt="user-avatar" class="img-circle img-fluid">
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="text-right">
                            <a href="{{route('add_expert.edit',$ex->id)}}" class="btn btn-sm btn-primary"><i class="fas fa-user"></i> Edit</a>
                            <a href="compose.html" class="btn btn-sm bg-teal"><i class="fas fa-comments"></i></a>
                            <a href="#" class="btn btn-sm btn-success"><i class="fas fa-user"></i> View Profile</a>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
<div class="card-footer">
    <nav aria-label="Custom Pagination">
        <ul class="pagination justify-content-center m-0">
            @if ($expert->onFirstPage())
                <li class="page-item disabled"><span class="page-link">&laquo;</span></li>
            @else
                <li class="page-item"><a class="page-link" href="{{ $expert->previousPageUrl() }}" rel="prev">&laquo;</a></li>
            @endif

            @foreach ($expert->getUrlRange(1, $expert->lastPage()) as $page => $url)
                <li class="page-item {{ $page == $expert->currentPage() ? 'active' : '' }}">
                    <a class="page-link" href="{{ $url }}">{{ $page }}</a>
                </li>
            @endforeach

            @if ($expert->hasMorePages())
                <li class="page-item"><a class="page-link" href="{{ $expert->nextPageUrl() }}" rel="next">&raquo;</a></li>
            @else
                <li class="page-item disabled"><span class="page-link">&raquo;</span></li>
            @endif
        </ul>
    </nav>
</div>

                  <!-- /.card-footer -->
               </div>

@endsection
