<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

use Session;

use App\Models\User;

use Hash;
class AuthController extends Controller
{
    /**

     * Write code on Method

     *

     * @return response()

     */

     public function index()

     {
 
         return view('auth.login');
 
     }  
 
       
 
     /**
 
      * Write code on Method
 
      *
 
      * @return response()
 
      */
 
     public function registration()
 
     {
 
         return view('auth.registration');
 
     }
 
       
 
     /**
 
      * Write code on Method
 
      *
 
      * @return response()
 
      */
 
     public function postLogin(Request $request)
 
     {
        
         $request->validate([
 
             'email' => 'required',
 
             'password' => 'required',
 
         ]);
 
    
 
         $credentials = $request->only('email', 'password');
 
         if (Auth::attempt($credentials)) {
 
             return redirect()->intended('dashboard')
 
                         ->withSuccess('You have Successfully loggedin');
 
         }
 
   
 
         return redirect("/")->withSuccess('Oppes! You have entered invalid credentials');
 
     }
 
       
 
     /**
 
      * Write code on Method
 
      *
 
      * @return response()
 
      */
 
     public function postRegistration(Request $request)
 
     {  
 
          $request->validate([
        'name' => 'required',
        'email' => 'required|email|unique:users',
        'password' => 'required|min:6',
    ]);

    // Create the user
    $data = $request->all();
    $user = $this->create($data);

    // Log the user in
    Auth::login($user);

    // Redirect to dashboard with success message
    return redirect("dashboard")->withSuccess('Great! You have successfully registered and logged in.');
 
     }
 
     
 
     /**
 
      * Write code on Method
 
      *
 
      * @return response()
 
      */
 
     public function dashboard()
 
     {
 
         if(Auth::check()){
 
             return view('dashboard');
 
         }
 
   
 
         return redirect("/")->withSuccess('Opps! You do not have access');
 
     }
 
     
 
     /**
 
      * Write code on Method
 
      *
 
      * @return response()
 
      */
 
     public function create(array $data)
 
     {
 
       return User::create([
 
         'name' => $data['name'],
 
         'email' => $data['email'],
 
         'password' => Hash::make($data['password'])
 
       ]);
 
     }
 
     
 
     /**
 
      * Write code on Method
 
      *
 
      * @return response()
 
      */
 
     public function logout() {
 
         Session::flush();
 
         Auth::logout();
 
   
 
         return Redirect('/');
 
     }
}
